// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/udp_socket.mojom
//

package org.chromium.mojom.mojo;

class UdpSocket_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<UdpSocket, UdpSocket.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<UdpSocket, UdpSocket.Proxy>() {
    
        public String getName() {
            return "mojo::UDPSocket";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, UdpSocket impl) {
            return new Stub(core, impl);
        }
    
        public UdpSocket[] buildArray(int size) {
          return new UdpSocket[size];
        }
    };

    private static final int ALLOW_ADDRESS_REUSE_ORDINAL = 0;
    private static final int BIND_ORDINAL = 1;
    private static final int CONNECT_ORDINAL = 2;
    private static final int SET_SEND_BUFFER_SIZE_ORDINAL = 3;
    private static final int SET_RECEIVE_BUFFER_SIZE_ORDINAL = 4;
    private static final int NEGOTIATE_MAX_PENDING_SEND_REQUESTS_ORDINAL = 5;
    private static final int RECEIVE_MORE_ORDINAL = 6;
    private static final int SEND_TO_ORDINAL = 7;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements UdpSocket.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void allowAddressReuse(AllowAddressReuseResponse callback) {
            UdpSocketAllowAddressReuseParams _message = new UdpSocketAllowAddressReuseParams();
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ALLOW_ADDRESS_REUSE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new UdpSocketAllowAddressReuseResponseParamsForwardToCallback(callback));
        }

        @Override
        public void bind(NetAddress addr, BindResponse callback) {
            UdpSocketBindParams _message = new UdpSocketBindParams();
            _message.addr = addr;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    BIND_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new UdpSocketBindResponseParamsForwardToCallback(callback));
        }

        @Override
        public void connect(NetAddress remoteAddr, ConnectResponse callback) {
            UdpSocketConnectParams _message = new UdpSocketConnectParams();
            _message.remoteAddr = remoteAddr;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new UdpSocketConnectResponseParamsForwardToCallback(callback));
        }

        @Override
        public void setSendBufferSize(int size, SetSendBufferSizeResponse callback) {
            UdpSocketSetSendBufferSizeParams _message = new UdpSocketSetSendBufferSizeParams();
            _message.size = size;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SET_SEND_BUFFER_SIZE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new UdpSocketSetSendBufferSizeResponseParamsForwardToCallback(callback));
        }

        @Override
        public void setReceiveBufferSize(int size, SetReceiveBufferSizeResponse callback) {
            UdpSocketSetReceiveBufferSizeParams _message = new UdpSocketSetReceiveBufferSizeParams();
            _message.size = size;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SET_RECEIVE_BUFFER_SIZE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new UdpSocketSetReceiveBufferSizeResponseParamsForwardToCallback(callback));
        }

        @Override
        public void negotiateMaxPendingSendRequests(int requestedSize, NegotiateMaxPendingSendRequestsResponse callback) {
            UdpSocketNegotiateMaxPendingSendRequestsParams _message = new UdpSocketNegotiateMaxPendingSendRequestsParams();
            _message.requestedSize = requestedSize;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    NEGOTIATE_MAX_PENDING_SEND_REQUESTS_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new UdpSocketNegotiateMaxPendingSendRequestsResponseParamsForwardToCallback(callback));
        }

        @Override
        public void receiveMore(int datagramNumber) {
            UdpSocketReceiveMoreParams _message = new UdpSocketReceiveMoreParams();
            _message.datagramNumber = datagramNumber;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(RECEIVE_MORE_ORDINAL)));
        }

        @Override
        public void sendTo(NetAddress destAddr, byte[] data, SendToResponse callback) {
            UdpSocketSendToParams _message = new UdpSocketSendToParams();
            _message.destAddr = destAddr;
            _message.data = data;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SEND_TO_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new UdpSocketSendToResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<UdpSocket> {

        Stub(org.chromium.mojo.system.Core core, UdpSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                UdpSocket_Internal.MANAGER, messageWithHeader);
                    case RECEIVE_MORE_ORDINAL: {
                        UdpSocketReceiveMoreParams data =
                                UdpSocketReceiveMoreParams.deserialize(messageWithHeader.getPayload());
                        getImpl().receiveMore(data.datagramNumber);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), UdpSocket_Internal.MANAGER, messageWithHeader, receiver);
                    case ALLOW_ADDRESS_REUSE_ORDINAL: {
                        UdpSocketAllowAddressReuseParams.deserialize(messageWithHeader.getPayload());
                        getImpl().allowAddressReuse(new UdpSocketAllowAddressReuseResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case BIND_ORDINAL: {
                        UdpSocketBindParams data =
                                UdpSocketBindParams.deserialize(messageWithHeader.getPayload());
                        getImpl().bind(data.addr, new UdpSocketBindResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case CONNECT_ORDINAL: {
                        UdpSocketConnectParams data =
                                UdpSocketConnectParams.deserialize(messageWithHeader.getPayload());
                        getImpl().connect(data.remoteAddr, new UdpSocketConnectResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case SET_SEND_BUFFER_SIZE_ORDINAL: {
                        UdpSocketSetSendBufferSizeParams data =
                                UdpSocketSetSendBufferSizeParams.deserialize(messageWithHeader.getPayload());
                        getImpl().setSendBufferSize(data.size, new UdpSocketSetSendBufferSizeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case SET_RECEIVE_BUFFER_SIZE_ORDINAL: {
                        UdpSocketSetReceiveBufferSizeParams data =
                                UdpSocketSetReceiveBufferSizeParams.deserialize(messageWithHeader.getPayload());
                        getImpl().setReceiveBufferSize(data.size, new UdpSocketSetReceiveBufferSizeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case NEGOTIATE_MAX_PENDING_SEND_REQUESTS_ORDINAL: {
                        UdpSocketNegotiateMaxPendingSendRequestsParams data =
                                UdpSocketNegotiateMaxPendingSendRequestsParams.deserialize(messageWithHeader.getPayload());
                        getImpl().negotiateMaxPendingSendRequests(data.requestedSize, new UdpSocketNegotiateMaxPendingSendRequestsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case SEND_TO_ORDINAL: {
                        UdpSocketSendToParams data =
                                UdpSocketSendToParams.deserialize(messageWithHeader.getPayload());
                        getImpl().sendTo(data.destAddr, data.data, new UdpSocketSendToResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class UdpSocketAllowAddressReuseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private UdpSocketAllowAddressReuseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketAllowAddressReuseParams() {
            this(0);
        }
    
        public static UdpSocketAllowAddressReuseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketAllowAddressReuseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketAllowAddressReuseParams result = new UdpSocketAllowAddressReuseParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

    static final class UdpSocketAllowAddressReuseResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
    
        private UdpSocketAllowAddressReuseResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketAllowAddressReuseResponseParams() {
            this(0);
        }
    
        public static UdpSocketAllowAddressReuseResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketAllowAddressReuseResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketAllowAddressReuseResponseParams result = new UdpSocketAllowAddressReuseResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketAllowAddressReuseResponseParams other = (UdpSocketAllowAddressReuseResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            return result;
        }
    }

    static class UdpSocketAllowAddressReuseResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final UdpSocket.AllowAddressReuseResponse mCallback;

        UdpSocketAllowAddressReuseResponseParamsForwardToCallback(UdpSocket.AllowAddressReuseResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ALLOW_ADDRESS_REUSE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                UdpSocketAllowAddressReuseResponseParams response = UdpSocketAllowAddressReuseResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class UdpSocketAllowAddressReuseResponseParamsProxyToResponder implements UdpSocket.AllowAddressReuseResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketAllowAddressReuseResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            UdpSocketAllowAddressReuseResponseParams _response = new UdpSocketAllowAddressReuseResponseParams();
            _response.result = result;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ALLOW_ADDRESS_REUSE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class UdpSocketBindParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetAddress addr;
    
        private UdpSocketBindParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketBindParams() {
            this(0);
        }
    
        public static UdpSocketBindParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketBindParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketBindParams result = new UdpSocketBindParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.addr = NetAddress.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(addr, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketBindParams other = (UdpSocketBindParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.addr, other.addr))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(addr);
            return result;
        }
    }

    static final class UdpSocketBindResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
        public NetAddress boundAddr;
        public org.chromium.mojo.bindings.InterfaceRequest<UdpSocketReceiver> receiver;
    
        private UdpSocketBindResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketBindResponseParams() {
            this(0);
        }
    
        public static UdpSocketBindResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketBindResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketBindResponseParams result = new UdpSocketBindResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.boundAddr = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiver = decoder0.readInterfaceRequest(24, true);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
            encoder0.encode(boundAddr, 16, true);
            encoder0.encode(receiver, 24, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketBindResponseParams other = (UdpSocketBindResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.boundAddr, other.boundAddr))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.receiver, other.receiver))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(boundAddr);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(receiver);
            return result;
        }
    }

    static class UdpSocketBindResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final UdpSocket.BindResponse mCallback;

        UdpSocketBindResponseParamsForwardToCallback(UdpSocket.BindResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(BIND_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                UdpSocketBindResponseParams response = UdpSocketBindResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result, response.boundAddr, response.receiver);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class UdpSocketBindResponseParamsProxyToResponder implements UdpSocket.BindResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketBindResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress boundAddr, org.chromium.mojo.bindings.InterfaceRequest<UdpSocketReceiver> receiver) {
            UdpSocketBindResponseParams _response = new UdpSocketBindResponseParams();
            _response.result = result;
            _response.boundAddr = boundAddr;
            _response.receiver = receiver;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    BIND_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class UdpSocketConnectParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetAddress remoteAddr;
    
        private UdpSocketConnectParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketConnectParams() {
            this(0);
        }
    
        public static UdpSocketConnectParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketConnectParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketConnectParams result = new UdpSocketConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.remoteAddr = NetAddress.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(remoteAddr, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketConnectParams other = (UdpSocketConnectParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.remoteAddr, other.remoteAddr))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(remoteAddr);
            return result;
        }
    }

    static final class UdpSocketConnectResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
        public NetAddress localAddr;
        public org.chromium.mojo.bindings.InterfaceRequest<UdpSocketReceiver> receiver;
    
        private UdpSocketConnectResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketConnectResponseParams() {
            this(0);
        }
    
        public static UdpSocketConnectResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketConnectResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketConnectResponseParams result = new UdpSocketConnectResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.localAddr = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiver = decoder0.readInterfaceRequest(24, true);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
            encoder0.encode(localAddr, 16, true);
            encoder0.encode(receiver, 24, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketConnectResponseParams other = (UdpSocketConnectResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.localAddr, other.localAddr))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.receiver, other.receiver))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(localAddr);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(receiver);
            return result;
        }
    }

    static class UdpSocketConnectResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final UdpSocket.ConnectResponse mCallback;

        UdpSocketConnectResponseParamsForwardToCallback(UdpSocket.ConnectResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CONNECT_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                UdpSocketConnectResponseParams response = UdpSocketConnectResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result, response.localAddr, response.receiver);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class UdpSocketConnectResponseParamsProxyToResponder implements UdpSocket.ConnectResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketConnectResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress localAddr, org.chromium.mojo.bindings.InterfaceRequest<UdpSocketReceiver> receiver) {
            UdpSocketConnectResponseParams _response = new UdpSocketConnectResponseParams();
            _response.result = result;
            _response.localAddr = localAddr;
            _response.receiver = receiver;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class UdpSocketSetSendBufferSizeParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int size;
    
        private UdpSocketSetSendBufferSizeParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketSetSendBufferSizeParams() {
            this(0);
        }
    
        public static UdpSocketSetSendBufferSizeParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketSetSendBufferSizeParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSetSendBufferSizeParams result = new UdpSocketSetSendBufferSizeParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.size = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(size, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketSetSendBufferSizeParams other = (UdpSocketSetSendBufferSizeParams) object;
            if (this.size != other.size)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(size);
            return result;
        }
    }

    static final class UdpSocketSetSendBufferSizeResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
    
        private UdpSocketSetSendBufferSizeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketSetSendBufferSizeResponseParams() {
            this(0);
        }
    
        public static UdpSocketSetSendBufferSizeResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketSetSendBufferSizeResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSetSendBufferSizeResponseParams result = new UdpSocketSetSendBufferSizeResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketSetSendBufferSizeResponseParams other = (UdpSocketSetSendBufferSizeResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            return result;
        }
    }

    static class UdpSocketSetSendBufferSizeResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final UdpSocket.SetSendBufferSizeResponse mCallback;

        UdpSocketSetSendBufferSizeResponseParamsForwardToCallback(UdpSocket.SetSendBufferSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_SEND_BUFFER_SIZE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                UdpSocketSetSendBufferSizeResponseParams response = UdpSocketSetSendBufferSizeResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class UdpSocketSetSendBufferSizeResponseParamsProxyToResponder implements UdpSocket.SetSendBufferSizeResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketSetSendBufferSizeResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            UdpSocketSetSendBufferSizeResponseParams _response = new UdpSocketSetSendBufferSizeResponseParams();
            _response.result = result;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SET_SEND_BUFFER_SIZE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class UdpSocketSetReceiveBufferSizeParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int size;
    
        private UdpSocketSetReceiveBufferSizeParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketSetReceiveBufferSizeParams() {
            this(0);
        }
    
        public static UdpSocketSetReceiveBufferSizeParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketSetReceiveBufferSizeParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSetReceiveBufferSizeParams result = new UdpSocketSetReceiveBufferSizeParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.size = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(size, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketSetReceiveBufferSizeParams other = (UdpSocketSetReceiveBufferSizeParams) object;
            if (this.size != other.size)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(size);
            return result;
        }
    }

    static final class UdpSocketSetReceiveBufferSizeResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
    
        private UdpSocketSetReceiveBufferSizeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketSetReceiveBufferSizeResponseParams() {
            this(0);
        }
    
        public static UdpSocketSetReceiveBufferSizeResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketSetReceiveBufferSizeResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSetReceiveBufferSizeResponseParams result = new UdpSocketSetReceiveBufferSizeResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketSetReceiveBufferSizeResponseParams other = (UdpSocketSetReceiveBufferSizeResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            return result;
        }
    }

    static class UdpSocketSetReceiveBufferSizeResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final UdpSocket.SetReceiveBufferSizeResponse mCallback;

        UdpSocketSetReceiveBufferSizeResponseParamsForwardToCallback(UdpSocket.SetReceiveBufferSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_RECEIVE_BUFFER_SIZE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                UdpSocketSetReceiveBufferSizeResponseParams response = UdpSocketSetReceiveBufferSizeResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class UdpSocketSetReceiveBufferSizeResponseParamsProxyToResponder implements UdpSocket.SetReceiveBufferSizeResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketSetReceiveBufferSizeResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            UdpSocketSetReceiveBufferSizeResponseParams _response = new UdpSocketSetReceiveBufferSizeResponseParams();
            _response.result = result;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SET_RECEIVE_BUFFER_SIZE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class UdpSocketNegotiateMaxPendingSendRequestsParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int requestedSize;
    
        private UdpSocketNegotiateMaxPendingSendRequestsParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketNegotiateMaxPendingSendRequestsParams() {
            this(0);
        }
    
        public static UdpSocketNegotiateMaxPendingSendRequestsParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketNegotiateMaxPendingSendRequestsParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketNegotiateMaxPendingSendRequestsParams result = new UdpSocketNegotiateMaxPendingSendRequestsParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.requestedSize = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(requestedSize, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketNegotiateMaxPendingSendRequestsParams other = (UdpSocketNegotiateMaxPendingSendRequestsParams) object;
            if (this.requestedSize != other.requestedSize)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(requestedSize);
            return result;
        }
    }

    static final class UdpSocketNegotiateMaxPendingSendRequestsResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int actualSize;
    
        private UdpSocketNegotiateMaxPendingSendRequestsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketNegotiateMaxPendingSendRequestsResponseParams() {
            this(0);
        }
    
        public static UdpSocketNegotiateMaxPendingSendRequestsResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketNegotiateMaxPendingSendRequestsResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketNegotiateMaxPendingSendRequestsResponseParams result = new UdpSocketNegotiateMaxPendingSendRequestsResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.actualSize = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(actualSize, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketNegotiateMaxPendingSendRequestsResponseParams other = (UdpSocketNegotiateMaxPendingSendRequestsResponseParams) object;
            if (this.actualSize != other.actualSize)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(actualSize);
            return result;
        }
    }

    static class UdpSocketNegotiateMaxPendingSendRequestsResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final UdpSocket.NegotiateMaxPendingSendRequestsResponse mCallback;

        UdpSocketNegotiateMaxPendingSendRequestsResponseParamsForwardToCallback(UdpSocket.NegotiateMaxPendingSendRequestsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(NEGOTIATE_MAX_PENDING_SEND_REQUESTS_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                UdpSocketNegotiateMaxPendingSendRequestsResponseParams response = UdpSocketNegotiateMaxPendingSendRequestsResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.actualSize);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class UdpSocketNegotiateMaxPendingSendRequestsResponseParamsProxyToResponder implements UdpSocket.NegotiateMaxPendingSendRequestsResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketNegotiateMaxPendingSendRequestsResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer actualSize) {
            UdpSocketNegotiateMaxPendingSendRequestsResponseParams _response = new UdpSocketNegotiateMaxPendingSendRequestsResponseParams();
            _response.actualSize = actualSize;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    NEGOTIATE_MAX_PENDING_SEND_REQUESTS_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class UdpSocketReceiveMoreParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int datagramNumber;
    
        private UdpSocketReceiveMoreParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketReceiveMoreParams() {
            this(0);
        }
    
        public static UdpSocketReceiveMoreParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketReceiveMoreParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketReceiveMoreParams result = new UdpSocketReceiveMoreParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.datagramNumber = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(datagramNumber, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketReceiveMoreParams other = (UdpSocketReceiveMoreParams) object;
            if (this.datagramNumber != other.datagramNumber)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(datagramNumber);
            return result;
        }
    }

    static final class UdpSocketSendToParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetAddress destAddr;
        public byte[] data;
    
        private UdpSocketSendToParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketSendToParams() {
            this(0);
        }
    
        public static UdpSocketSendToParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketSendToParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSendToParams result = new UdpSocketSendToParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                result.destAddr = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.data = decoder0.readBytes(16, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(destAddr, 8, true);
            encoder0.encode(data, 16, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketSendToParams other = (UdpSocketSendToParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.destAddr, other.destAddr))
                return false;
            if (!java.util.Arrays.equals(this.data, other.data))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(destAddr);
            result = prime * result + java.util.Arrays.hashCode(data);
            return result;
        }
    }

    static final class UdpSocketSendToResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
    
        private UdpSocketSendToResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public UdpSocketSendToResponseParams() {
            this(0);
        }
    
        public static UdpSocketSendToResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static UdpSocketSendToResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSendToResponseParams result = new UdpSocketSendToResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            UdpSocketSendToResponseParams other = (UdpSocketSendToResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            return result;
        }
    }

    static class UdpSocketSendToResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final UdpSocket.SendToResponse mCallback;

        UdpSocketSendToResponseParamsForwardToCallback(UdpSocket.SendToResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SEND_TO_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                UdpSocketSendToResponseParams response = UdpSocketSendToResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class UdpSocketSendToResponseParamsProxyToResponder implements UdpSocket.SendToResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketSendToResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            UdpSocketSendToResponseParams _response = new UdpSocketSendToResponseParams();
            _response.result = result;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SEND_TO_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

